% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_placement_groups}
\alias{ec2_describe_placement_groups}
\title{Describe Placement Groups}
\usage{
ec2_describe_placement_groups(
  Filter = NULL,
  DryRun = NULL,
  GroupName = NULL,
  GroupId = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{GroupName}{List.   The names of the placement groups.[optional]}

\item{GroupId}{List. The IDs of the placement groups.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the specified placement groups
or all of your placement groups. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement groups}
in the \emph{Amazon EC2 User Guide}.
}
\section{Filter}{


The filters.
\itemize{
\item \code{group-name} - The name of the placement group.
\item \code{state} - The state of the placement group (\code{pending} \| \code{available}
\| \code{deleting} \| \code{deleted}).
\item \code{strategy} - The strategy of the placement group (\code{cluster} \|
\code{spread} \| \code{partition}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources that have a tag with a specific key,
regardless of the tag value.
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{GroupName}{


The names of the placement groups.

Default: Describes all your placement groups, or only those otherwise
specified.
}

\section{GroupId}{

The IDs of the placement
groups.
}

