% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpc_classic_link_dns_support}
\alias{ec2_describe_vpc_classic_link_dns_support}
\title{Describe Vpc Classic Link Dns Support}
\usage{
ec2_describe_vpc_classic_link_dns_support(
  MaxResults = NULL,
  NextToken = NULL,
  VpcIds = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{VpcIds}{List. One or more VPC IDs.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the ClassicLink DNS support
status of one or more VPCs. If enabled, the DNS hostname of a linked
EC2-Classic instance resolves to its private IP address when addressed
from an instance in the VPC to which it\'s linked. Similarly, the DNS
hostname of an instance in a VPC resolves to its private IP address when
addressed from a linked EC2-Classic instance. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon Elastic Compute Cloud User
Guide}.
}
\section{MaxResults}{

The
maximum number of results to return with a single call. To retrieve the
remaining results, make another call with the returned \code{nextToken}
value.
}

\section{VpcIds}{

One or more VPC
IDs.
}

