% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_endpoint_service_configuration}
\alias{ec2_modify_vpc_endpoint_service_configuration}
\title{Modify Vpc Endpoint Service Configuration}
\usage{
ec2_modify_vpc_endpoint_service_configuration(
  ServiceId,
  DryRun = NULL,
  PrivateDnsName = NULL,
  RemovePrivateDnsName = NULL,
  AcceptanceRequired = NULL,
  AddNetworkLoadBalancerArn = NULL,
  RemoveNetworkLoadBalancerArn = NULL,
  AddGatewayLoadBalancerArn = NULL,
  RemoveGatewayLoadBalancerArn = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ServiceId}{String. The ID of the service.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{PrivateDnsName}{String. (Interface endpoint configuration) The private DNS name to assign to the endpoint service.[optional]}

\item{RemovePrivateDnsName}{Logical. (Interface endpoint configuration) Removes the private DNS name of the endpoint service.[optional]}

\item{AcceptanceRequired}{Logical. Indicates whether requests to create an endpoint to your service must be accepted.[optional]}

\item{AddNetworkLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.[optional]}

\item{RemoveNetworkLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration....[optional]}

\item{AddGatewayLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration.[optional]}

\item{RemoveGatewayLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration....[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Vpc Endpoint Service Configuration
}
\section{ServiceId}{

The ID of the
service.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{PrivateDnsName}{

(Interface endpoint
configuration) The private DNS name to assign to the endpoint
service.
}

\section{RemovePrivateDnsName}{

(Interface endpoint configuration) Removes
the private DNS name of the endpoint
service.
}

\section{AcceptanceRequired}{

Indicates whether requests to create an
endpoint to your service must be accepted.
}

\section{AddNetworkLoadBalancerArn}{

The
Amazon Resource Names (ARNs) of Network Load Balancers to add to your
service configuration.
}

\section{RemoveNetworkLoadBalancerArn}{

The Amazon Resource Names
(ARNs) of Network Load Balancers to remove from your service
configuration.
}

\section{AddGatewayLoadBalancerArn}{

The Amazon Resource Names (ARNs) of
Gateway Load Balancers to add to your service
configuration.
}

\section{RemoveGatewayLoadBalancerArn}{

The Amazon Resource Names (ARNs) of
Gateway Load Balancers to remove from your service
configuration.
}

