% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_reject_transit_gateway_multicast_domain_associations}
\alias{ec2_reject_transit_gateway_multicast_domain_associations}
\title{Reject Transit Gateway Multicast Domain Associations}
\usage{
ec2_reject_transit_gateway_multicast_domain_associations(
  TransitGatewayMulticastDomainId = NULL,
  TransitGatewayAttachmentId = NULL,
  SubnetIds = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{String. The ID of the transit gateway multicast domain.[optional]}

\item{TransitGatewayAttachmentId}{String. The ID of the transit gateway attachment.[optional]}

\item{SubnetIds}{List. The IDs of the subnets to associate with the transit gateway multicast domain.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Rejects a request to associate cross-account
subnets with a transit gateway multicast
domain.
}
\section{TransitGatewayMulticastDomainId}{

The ID of the transit
gateway multicast domain.
}

\section{TransitGatewayAttachmentId}{

The ID of the transit
gateway attachment.
}

\section{SubnetIds}{

The IDs of the subnets to
associate with the transit gateway multicast
domain.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

