% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_transit_gateway_vpc_attachment}
\alias{ec2_create_transit_gateway_vpc_attachment}
\title{Create Transit Gateway Vpc Attachment}
\usage{
ec2_create_transit_gateway_vpc_attachment(
  TransitGatewayId,
  VpcId,
  SubnetIds,
  Options = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{TransitGatewayId}{Character. The ID of the transit gateway.}

\item{VpcId}{Character. The ID of the VPC.}

\item{SubnetIds}{List. The IDs of one or more subnets.}

\item{Options}{Object. The VPC attachment options.[optional]}

\item{TagSpecifications}{List. The tags to apply to the VPC attachment.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Transit Gateway Vpc Attachment
}
\section{TransitGatewayId}{

The ID of the transit
gateway.
}

\section{VpcId}{

The ID of the VPC.
}

\section{SubnetIds}{

The
IDs of one or more subnets. You can specify only one subnet per
Availability Zone. You must specify at least one subnet, but we
recommend that you specify two subnets for better availability. The
transit gateway uses one IP address from each specified
subnet.
}

\section{Options}{

The VPC attachment
options.
}

\section{TagSpecifications}{

The tags to apply to the VPC
attachment.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

