% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_host_reservation_offerings}
\alias{ec2_describe_host_reservation_offerings}
\title{Describe Host Reservation Offerings}
\usage{
ec2_describe_host_reservation_offerings(
  Filter = NULL,
  MaxDuration = NULL,
  MaxResults = NULL,
  MinDuration = NULL,
  NextToken = NULL,
  OfferingId = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxDuration}{Integer. This is the maximum duration of the reservation to purchase, specified in seconds.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{MinDuration}{Integer. This is the minimum duration of the reservation you\'d like to purchase, specified in seconds.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{OfferingId}{Character. The ID of the reservation offering.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Host Reservation Offerings
}
\section{Filter}{


The filters.
\itemize{
\item \code{instance-family} - The instance family of the offering (for
example, \code{m4}).
\item \code{payment-option} - The payment option (\code{NoUpfront} \|
\code{PartialUpfront} \| \code{AllUpfront}).
}
}

\section{MaxDuration}{

This is the maximum duration of the reservation to
purchase, specified in seconds. Reservations are available in one-year
and three-year terms. The number of seconds specified must be the number
of seconds in a year (365x24x60x60) times one of the supported durations
(1 or 3). For example, specify 94608000 for three
years.
}

\section{MaxResults}{

The maximum number of results to return for
the request in a single page. The remaining results can be seen by
sending another request with the returned \code{nextToken} value. This value
can be between 5 and 500. If \code{maxResults} is given a larger value than
500, you receive an error.
}

\section{MinDuration}{

This is the minimum
duration of the reservation you\'d like to purchase, specified in
seconds. Reservations are available in one-year and three-year terms.
The number of seconds specified must be the number of seconds in a year
(365x24x60x60) times one of the supported durations (1 or 3). For
example, specify 31536000 for one year.
}

\section{OfferingId}{

The ID of
the reservation offering.
}

