% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_object.R
\name{get_object}
\alias{get_object}
\alias{save_object}
\alias{head_object}
\title{Get object}
\usage{
get_object(object, bucket, headers = list(), parse_response = FALSE, ...)

save_object(object, bucket, file, headers = list(), ...)

head_object(object, bucket, ...)
}
\arguments{
\item{object}{Character string with the object key, or an object of class \dQuote{s3_object}. In most cases, if \code{object} is specified as the latter, \code{bucket} can be omitted because the bucket name will be extracted from \dQuote{Bucket} slot in \code{object}.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{headers}{List of request headers for the REST call.}

\item{parse_response}{Passed through to \code{\link{s3HTTP}}, as this function requires a non-default setting. There is probably no reason to ever change this.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{file}{An R connection, or file name specifying the local file to save the object into.}
}
\value{
If \code{file = NULL}, a raw object. Otherwise, a character string containing the file name that the object is saved to.
}
\description{
Retrieve an object from an S3 bucket
}
\details{
\code{get_object} retrieves an object into memory as a raw vector. \code{save_object} saves an object to a local file. \code{head_object} checks whether an object exists by executing an HTTP HEAD request; this can be useful for checking object headers such as \dQuote{content-length} or \dQuote{content-type}.

Some users may find the raw vector response format of \code{get_object} unfamiliar. The object will also carry attributes, including \dQuote{content-type}, which may be useful for deciding how to subsequently process the vector. Two common strategies are as follows. For text content types, running \code{\link[base]{charToRaw}} may be the most useful first step to make the response human-readable. Alternatively, converting the raw vector into a connection using \code{\link[base]{rawConnection}} may also be useful, as that can often then be passed to parsing functions just like a file connection would be.
}
\examples{
\dontrun{
  # get an object in memory
  ## create bucket
  b <- put_bucket("myexamplebucket")
  
  ## save a dataset to the bucket
  s3save(mtcars, bucket = b, object = "mtcars")
  obj <- get_bucket(b)
  ## get the object in memory
  x <- get_object(obj[[1]])
  load(rawConnection(x))
  "mtcars" \%in\% ls()

  # save an object locally
  y <- save_object(obj[[1]], file = object[[1]][["Key"]])
  y \%in\% dir()

  # return object using 'S3 URI' syntax
  get_object("s3://myexamplebucket/mtcars")

  # return parts of an object
  ## use 'Range' header to specify bytes
  get_object(object = obj[[1]], headers = list('Range' = 'bytes=1-120'))
}
}
\references{
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html}{API Documentation: GET Object}

\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html}{API Documentation: GET Object torrent}

\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectHEAD.html}{API Document: HEAD Object}
}
\seealso{
\code{\link{get_bucket}}, \code{\link{put_object}}, \code{\link{delete_object}}
}
