% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdsm.R
\name{sdsm}
\alias{sdsm}
\title{The stochastic degree sequence model (sdsm) for backbone probabilities}
\usage{
sdsm(B, progress = FALSE, method = "RefinedNormal", ...)
}
\arguments{
\item{B}{graph: An unweighted bipartite graph object of class matrix, sparse matrix, igraph, edgelist, or network object.
Any rows and columns of the associated bipartite matrix that contain only zeros are automatically removed before computations.}

\item{progress}{Boolean: If \link[utils]{txtProgressBar} should be used to measure progress}

\item{method}{string: Specifies the method of the Poisson Binomial distribution computation used by the ``ppbinom" function in \link[PoissonBinomial]{PoissonBinomial-Distribution}.
"RefinedNormal" gives quick, very accurate approximations, while "DivideFFT" gives the quickest exact computations.}

\item{...}{optional arguments}
}
\value{
backbone, a list(positive, negative, summary). Here
    `positive` is a matrix of probabilities of edge weights being equal to or above the observed value in the projection,
    `negative` is a matrix of probabilities of edge weights being equal to or below the observed value in the projection, and
    `summary` is a data frame summary of the inputted matrix and the model used including: model name, number of rows, skew of row sums, number of columns, skew of column sums, and running time.
}
\description{
`sdsm` computes the probability of edge weights being
    above or below the observed edge weights in a bipartite projection
    using the stochastic degree sequence model.
    Once computed, use \code{\link{backbone.extract}} to return
    the backbone matrix for a given alpha value.
}
\details{
Specifically, the sdsm function compares an edge's observed weight in the projection \code{B*t(B)}
   to the distribution of weights expected in a projection obtained from a random bipartite network where
   both the row vertex degrees and column vertex degrees are approximately fixed.

sdsm uses the Bipartite Configuration Model \link{bicm} (Saracco et. al (2015, 2017)) to compute probabilities for the Poisson binomial distribution.

The "backbone" S3 class object returned is composed of two matrices, and a summary dataframe.
}
\examples{
sdsm_probs <- sdsm(davis)
}
\references{
sdsm: {Neal, Z. P. (2014). The backbone of bipartite projections: Inferring relationships from co-authorship, co-sponsorship, co-attendance, and other co-behaviors. Social Networks, 39, Elsevier: 84-97. \doi{10.1016/j.socnet.2014.06.001}}

bicm: {Saracco, F., Straka, M. J., Clemente, R. D., Gabrielli, A., Caldarelli, G., & Squartini, T. (2017). Inferring monopartite projections of bipartite networks: An entropy-based approach. New Journal of Physics, 19(5), 053022. \doi{10.1088/1367-2630/aa6b38}}

bicm: {Saracco, F., Di Clemente, R., Gabrielli, A., & Squartini, T. (2015). Randomizing bipartite networks: The case of the World Trade Web. Scientific Reports, 5(1), 10595. \doi{10.1038/srep10595}}
}
