% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedrow.R
\name{hyperg}
\alias{hyperg}
\title{A wrapper for the \link{fixedrow} function}
\usage{
hyperg(B)
}
\arguments{
\item{B}{graph: An unweighted bipartite graph object of class matrix, sparse matrix, igraph, edgelist, or network object.
Any rows and columns of the associated bipartite matrix that contain only zeros are automatically removed before computations.}
}
\value{
\link{fixedrow}
}
\description{
`hyperg` computes the probability of observing
    a higher or lower edge weight using the hypergeometric distribution.
    Once computed, use \code{\link{backbone.extract}} to return
    the backbone matrix for a given alpha value.
}
\details{
Specifically, this function compares an edge's observed weight in the projection \eqn{B*t(B)} to the
    distribution of weights expected in a projection obtained from a random bipartite graph where
    the row vertex degrees are fixed but the column vertex degrees are allowed to vary.
}
\examples{
hyperg_probs <- hyperg(davis)
}
\references{
{Tumminello, Michele and Miccichè, Salvatore and Lillo, Fabrizio and Piilo, Jyrki and Mantegna, Rosario N. 2011. "Statistically Validated Networks in Bipartite Complex Systems." PLOS ONE, 6(3), \doi{10.1371/journal.pone.0017994}}

{Neal, Zachary. 2013. “Identifying Statistically Significant Edges in One-Mode Projections.” Social Network Analysis and Mining 3 (4). Springer: 915–24. \doi{10.1007/s13278-013-0107-y}}
}
