% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSSHeat.R
\name{NSSHeat}
\alias{NSSHeat}
\title{Construct heatmap for non-steady state (NSS) analysis}
\usage{
NSSHeat(
  bakRFit,
  DE_df,
  bakRModel = c("MLE", "Hybrid", "MCMC"),
  DE_cutoff = 0.05,
  bakR_cutoff = 0.05,
  Exp_ID = 2,
  lid = 4
)
}
\arguments{
\item{bakRFit}{bakRFit object}

\item{DE_df}{dataframe of required format with differential expression analysis results. See
Further-Analyses vignette for details on what this dataframe should look like}

\item{bakRModel}{Model fit from which bakR implementation should be used? Options are MLE, Hybrid,
or MCMC}

\item{DE_cutoff}{padj cutoff for calling a gene differentially expressed}

\item{bakR_cutoff}{padj cutoff for calling a fraction new significantly changed}

\item{Exp_ID}{Exp_ID of experimental sample whose comparison to the reference sample you want to use.
Only one reference vs. experimental sample comparison can be used at a time}

\item{lid}{Maximum absolute value for standardized score present in output. This is for improving
aesthetics of any heatmap generated with the output.}
}
\value{
returns data frame that can be passed to pheatmap::pheatmap()
}
\description{
This uses the output of bakR and a differential expression analysis software to construct
a dataframe that can be passed to pheatmap::pheatmap(). This heatmap will display the
result of a steady-state quasi-independent analysis of NR-seq data.
}
\examples{
\donttest{
# Simulate small dataset
sim <- Simulate_bakRData(100, nreps = 2)

# Analyze data with bakRFit
Fit <- bakRFit(sim$bakRData)

# Number of features that made it past filtering
NF <- nrow(Fit$Fast_Fit$Effects_df)

# Simulate mock differential expression data frame
DE_df <- data.frame(XF = as.character(1:NF),
                       log2FoldChange = stats::rnorm(NF, 0, 2))

DE_df$stat <- DE_df$log2FoldChange/0.5

DE_df$padj <- 2*stats::dnorm(-abs(DE_df$stat))

# make heatmap matrix
Heatmap <- NSSHeat(bakRFit = Fit,
               DE_df = DE_df,
               bakRModel = "MLE")

}
}
