% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.plot.R
\name{balance.combine}
\alias{balance.combine}
\title{Combine Two Sub-Plots}
\usage{
balance.combine(balance.partition, balance.distribution, size = "first")
}
\arguments{
\item{balance.partition}{A \code{ggplot} object. The "partition" sub-plot.}

\item{balance.distribution}{A \code{ggplot} object. The "distribution" sub-plot.}

\item{size}{A string. Toggles whether to size final figure based on
"first" (partition) or "last" (distribution) figure provided.}
}
\description{
This function combines the "partition" sub-plot with the
 "distribution" sub-plot, preserving scale.
}
\examples{
library(balance)
data(iris)
x <- iris[,1:4]
sbp <- sbp.fromPBA(x)
res <- balance(x, sbp)
custom1 <- res[[1]] + ggplot2::theme_dark()
custom2 <- res[[2]] + ggplot2::theme_dark()
balance.combine(custom1, custom2)

}
\author{
Thom Quinn
}
