% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBanterModel.R
\name{getBanterModel}
\alias{getBanterModel}
\title{Extract Random Forest Model}
\usage{
getBanterModel(x, model = "event")
}
\arguments{
\item{x}{a \code{\link{banter_model}} object.}

\item{model}{name of model to extract. Default is \code{"event"} 
to summarize the event-level model. Can also be name of a detector.}
}
\value{
a \code{\link{randomForest}} model object.
}
\description{
Extract BANTER event or detector Random Forest model.
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 1, num.cores = 1
)
# run BANTER event model
bant.mdl <- runBanterModel(bant.mdl, ntree = 1000, sampsize = 1)

# extract the event randomForest model
library(randomForest)
event.rf <- getBanterModel(bant.mdl)
event.rf

# extract the burst pulse (bp) detector model
bp.rf <- getBanterModel(bant.mdl, "bp")
bp.rf

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
