% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_edge_code.R
\name{edge_code}
\alias{edge_code}
\title{\strong{Edge Code}}
\usage{
edge_code(df, height_var_name = "b_height")
}
\arguments{
\item{df}{A dataframe that, at a minimum, includes the following columns: batter height (b_height), the batter's handedness (stand), vertical location of the pitch (pz), and then horizontal location of the pitch (pz)}

\item{height_var_name}{The name of the variable in the data set that includes the batter's height. Defaults to b_height which assumes an height + inch format. If the variable name is "Height" it assumes the variable is already converted to inches (as is the case in some databases)}
}
\value{
Returns a tibble with the additional edge columns necessary for calculations.
}
\description{
This function allows you to classify individual pitches based on the various categories from the Edge\% metric. The dataframe passed to the function must include the batter's handedness, the px and pz coordinates from the PITCHf/x system, and the batter's height.
}
