% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableCell.R
\docType{class}
\name{TableCell}
\alias{TableCell}
\title{A class that represents a cell in a table}
\format{\code{\link{R6Class}} object.}
\usage{
TableCell
}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define a single table cell
}
\description{
The TableCell class represents a cell in a table.  Both header cells and body
cells are represented by this class.
}
\section{Fields}{

\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{rowNumber}}{The row number of the cell.  1 = the first (i.e. top) data
row.}

\item{\code{columnNumber}}{The column number of the cell.  1 = the first (i.e.
leftmost) data column.}

\item{\code{cellType}}{One of the following values that specifies the type of cell:
root, rowHeader, columnHeader, cell, total.  The cellType controls the
default styling that is applied to the cell.}

\item{\code{visible}}{TRUE or FALSE to specify whether the cell is rendered.}

\item{\code{rawValue}}{The original unformatted value.}

\item{\code{formattedValue}}{The formatted value (i.e. normally of character data
type).}

\item{\code{asNBSP}}{TRUE or FALSE to specify whether cells with no formatted
value be output as html nbsp.}

\item{\code{baseStyleName}}{The name of the style applied to this cell (a character
value).  The style must exist in the TableStyles object associated with the
table.}

\item{\code{style}}{A TableStyle object that can apply overrides to the base style
for this cell.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new table cell, specifying the field
  values documented above.}

  \item{\code{getCopy())}}{Get a copy of this cell.}
  \item{\code{asList())}}{Get a list representation of this cell}
  \item{\code{asJSON()}}{Get a JSON representation of this cell}
}
}

\examples{
# This class should only be created by using the functions in the table.
# It is not intended to be created by users outside of the table.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
cell1 <- tbl$cells$setCell(r=4, c=1, cellType="cell", rawValue=5)
cell2 <- tbl$cells$setCell(r=4, c=2, cellType="cell", rawValue=6)
tbl$renderTable()
}
\keyword{datasets}
