% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{weights_separate}
\alias{weights_separate}
\alias{weights_separate,OneStageBasket-method}
\alias{weights_separate,TwoStageBasket-method}
\title{Separate Analysis in Each Basket}
\usage{
weights_separate(design, ...)

\S4method{weights_separate}{OneStageBasket}(design, n, ...)

\S4method{weights_separate}{TwoStageBasket}(design, n, n1, ...)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}
}
\value{
A weight matrix where all weights are 0.
}
\description{
Separate Analysis in Each Basket
}
\details{
When \code{weights_separate} is used as a weight function, a
separate analysis performed in each basket.
}
\section{Methods (by class)}{
\itemize{
\item \code{weights_separate(OneStageBasket)}: Separate analysis for a single-stage basket
design

\item \code{weights_separate(TwoStageBasket)}: Separate analysis for a two-stage basket
design

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
toer(design, n = 15, lambda = 0.99, weight_fun = weights_separate)
}
