% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{getStanResults}
\alias{getStanResults}
\alias{getStanResults,bayesGAMfit-method}
\title{Returns the \code{stanfit} object generated by \pkg{rstan}}
\usage{
getStanResults(object)

\S4method{getStanResults}{bayesGAMfit}(object)
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} returned from \code{bayesGAM}}
}
\value{
Contents of \code{stanfit} results
}
\description{
Contains the full content of the \code{stanfit} object
}
\examples{
require(stats); require(graphics)
f <- bayesGAM(weight ~ np(height), data = women, family = gaussian, 
              iter = 500, chains = 1)
sres <- getStanResults(f)
plot(sres) # rstan method
}
