% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_outputs.R
\name{get.mig.prediction}
\alias{get.mig.prediction}
\alias{has.mig.prediction}
\title{Access Prediction Object}
\usage{
get.mig.prediction(mcmc = NULL, sim.dir = NULL, mcmc.dir = NULL)

has.mig.prediction(mcmc = NULL, sim.dir = NULL)
}
\arguments{
\item{mcmc}{Object of class \code{\link{bayesMig.mcmc.set}} used to make the prediction. 
If it is \code{NULL}, the prediction is loaded from directory given by \code{sim.dir}.}

\item{sim.dir}{Directory where the prediction is stored.}

\item{mcmc.dir}{Optional argument to be used only in a special case when the mcmc object 
contained in the prediction object was estimated in different directory than in the one 
to which it points to (for example due to moving or renaming the original directory). 
The argument causes that the mcmc is redirected to the given directory. 
It can be set to \code{NA} if no loading of the mcmc object is desired.}
}
\value{
Function \code{get.mig.prediction} returns an object of class \code{\link{bayesMig.prediction}}.

Function \code{has.mig.prediction} returns  a logical indicating if a prediction exists.
}
\description{
Function \code{get.mig.prediction} retrieves results of a prediction and creates an object of class
    \code{\link{bayesMig.prediction}}. Function \code{has.mig.prediction} checks an existence of such results.
}
\details{
If \code{mcmc} is not \code{NULL}, the search directory is set to 
    \code{mcmc$meta$output.dir}. This approach assumes that the prediction was stored in the 
    same directory as the MCMC simulation, i.e. the \code{output.dir} argument of the 
    \code{\link{mig.predict}} function was set to \code{NULL}. If it is not the case, 
    the argument \code{mcmc.dir} should be used.
}
