% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bayesbr.R
\name{print.bayesbr}
\alias{print.bayesbr}
\title{Print for \code{bayesbr} Objects}
\usage{
\method{print}{bayesbr}(x,...)
}
\arguments{
\item{x}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
A method that receives a list of the bayesbr type and its items and displays the estimated coefficients.
}
\examples{
data("bodyfat",package="bayesbr")
\dontshow{
lines = sample(1:251,50)
bodyfat = bodyfat[lines,]
}
bbr = bayesbr(brozek ~ wrist + density:thigh |chest, data = bodyfat,
             iter = 100)
print(bbr)
}
\seealso{
\code{\link{bayesbr}}, \code{\link{summary.bayesbr}}, \code{\link{residuals.bayesbr}}
}
