% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{ci}
\alias{ci.numeric}
\alias{ci.stanreg}
\alias{ci.brmsfit}
\title{Confidence/Credible Interval}
\usage{
ci(x, ...)

\method{ci}{numeric}(x, ci = 0.9, verbose = TRUE, ...)

\method{ci}{stanreg}(x, ci = 0.9, effects = c("fixed", "random",
  "all"), parameters = NULL, verbose = TRUE, ...)

\method{ci}{brmsfit}(x, ci = 0.9, effects = c("fixed", "random",
  "all"), component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL, verbose = TRUE, ...)
}
\arguments{
\item{x}{A \code{stanreg} or \code{brmsfit} model , or a vector representing a posterior distribution.}

\item{...}{Currently not used.}

\item{ci}{Value or vector of probability of the interval (between 0 and 1)
to be estimated. Named Credible Interval (CI) for consistency.}

\item{verbose}{Toggle off warnings.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}

\item{component}{Should results for all parameters, parameters for the conditional model
or the zero-inflated part of the model be returned? May be abbreviated. Only
applies to \pkg{brms}-models.}
}
\value{
A data frame with following columns:
  \itemize{
    \item \code{Parameter} The model parameter(s), if \code{x} is a model-object. If \code{x} is a vector, this column is missing.
    \item \code{CI} The probability of the credible interval.
    \item \code{CI_low} , \code{CI_high} The lower and upper credible interval limits for the parameters.
  }
}
\description{
Compute Confidence/Credible Intervals (CI) for Bayesian and frequentist models using quantiles.
}
\details{
Documentation is accessible for:
\itemize{
  \item \href{https://easystats.github.io/bayestestR/reference/ci.html}{Bayesian models}
}
}
\examples{
library(bayestestR)

ci(rnorm(1000))
\dontrun{
library(rstanarm)
model <- rstanarm::stan_glm(mpg ~ wt + cyl, data = mtcars)
ci(model)
ci(model, ci = c(.80, .90, .95))

library(brms)
model <- brms::brm(mpg ~ wt + cyl, data = mtcars)
ci(model)
ci(model, ci = c(.80, .90, .95))
}

}
