% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_ci.R
\name{reshape_ci}
\alias{reshape_ci}
\title{Reshape CI between wide/long formats}
\usage{
reshape_ci(x)
}
\arguments{
\item{x}{A data.frame containing \code{CI_low} and \code{CI_high}.}
}
\description{
Reshape CI between wide/long formats.
}
\examples{
library(bayestestR)

x <- data.frame(replicate(4, rnorm(100)))
x <- ci(x, ci = c(0.68, 0.89, 0.95))
reshape_ci(x)
reshape_ci(reshape_ci(x))

x <- data.frame(replicate(4, rnorm(100)))
x <- describe_posterior(x, ci = c(0.68, 0.89, 0.95))
reshape_ci(x)
reshape_ci(reshape_ci(x))
}
