% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_prior.R
\name{check_prior}
\alias{check_prior}
\title{Check if Prior is Informative}
\usage{
check_prior(model, method = "gelman", simulate_priors = TRUE, ...)
}
\arguments{
\item{model}{A \code{stanreg}, \code{stanfit}, or \code{brmsfit} object.}

\item{method}{Can be "gelman" or "lakeland". For the "gelman" method, if the SD of the posterior is more than 0.1 times the SD of the prior, then the prior is considered as informative. For the "lakeland" method, the prior is considered as informative if the posterior falls within the 95\% HDI of the prior.}

\item{simulate_priors}{Should prior distributions be simulated using
\code{\link{simulate_prior}} (default; faster) or sampled via \code{\link{unupdate}} (slower, more accurate).}

\item{...}{Currently not used.}
}
\description{
Performs a simple test to check whether the prior is informative to the posterior. This idea, and the accompanying heuristics, were discussed in \href{https://statmodeling.stat.columbia.edu/2019/08/10/}{this blogpost}.
}
\examples{
\dontrun{
library(bayestestR)
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ wt + am, data = mtcars, chains = 1, refresh = 0)
  check_prior(model, method = "gelman")
  check_prior(model, method = "lakeland")

  # An extreme example where both methods diverge:
  model <- stan_glm(mpg ~ wt, data = mtcars[1:3,],
                    prior = normal(-3.3, 1, FALSE),
                    prior_intercept = normal(0, 1000, FALSE),
                    refresh = 0)
  check_prior(model, method = "gelman")
  check_prior(model, method = "lakeland")
  plot(si(model)) # can provide visual confirmation to the Lakeland method
}
}
}
\references{
https://statmodeling.stat.columbia.edu/2019/08/10/
}
