% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub.R
\name{mgsub}
\alias{mgsub}
\title{Multiple gsub}
\usage{
mgsub(pattern, replacement, x, ...)
}
\arguments{
\item{pattern}{character vector containing regular expressions 
to be matched in the given character vector.}

\item{replacement}{a replacement vector of the same length as \code{pattern} for matched pattern. 
Coerced to character if possible.}

\item{x}{vector or NULL: the values to be matched against.}

\item{...}{additional parameters to be passed to \code{gsub}.}
}
\value{
A character vector of the same length as \code{x}.
}
\description{
The function \code{mgsub} is a `multiple' version of \code{\link{gsub}}.
}
\examples{
mgsub(c("aa", "AA"), c("bb", "BB"), c("XXaaccAACC", "YYaaccAACC", "ZZaaccAACC"))

}
\seealso{
\code{\link[base]{gsub}} from package \pkg{base}.
}
\author{
Theodore Lytras on StackOverflow, see \url{http://stackoverflow.com/a/15254254/3902976}
}
