% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjectiveRFunMany.R
\name{ObjectiveRFunMany}
\alias{ObjectiveRFunMany}
\title{Objective Interface with Custom R Function}
\description{
Objective interface where the user can pass a custom R function that expects a list of configurations as input.
If the return of the function is unnamed, it is named with the ids of the codomain.
}
\examples{
# define objective function
fun = function(xss) {
  res = lapply(xss, function(xs) -(xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10)
  data.table::data.table(y = as.numeric(res))
}

# set domain
domain = ps(
  x1 = p_dbl(-10, 10),
  x2 = p_dbl(-5, 5)
)

# set codomain
codomain = ps(
  y = p_dbl(tags = "maximize")
)

# create objective
objective = ObjectiveRFunMany$new(
  fun = fun,
  domain = domain,
  codomain = codomain,
  properties = "deterministic"
)

# evaluate objective function
objective$eval(list(x1 = 1, x2 = 2))

# evaluate multiple input values
objective$eval_many(list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4)))

# evaluate multiple input values as data.table
objective$eval_dt(data.table::data.table(x1 = 1:2, x2 = 3:4))
}
\seealso{
\link{ObjectiveRFun}, \link{ObjectiveRFunDt}
}
\section{Super class}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{ObjectiveRFunMany}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
Objective function.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ObjectiveRFunMany-new}{\code{ObjectiveRFunMany$new()}}
\item \href{#method-ObjectiveRFunMany-eval_many}{\code{ObjectiveRFunMany$eval_many()}}
\item \href{#method-ObjectiveRFunMany-clone}{\code{ObjectiveRFunMany$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval_dt"><a href='../../bbotk/html/Objective.html#method-Objective-eval_dt'><code>bbotk::Objective$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunMany-new"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunMany-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunMany$new(
  fun,
  domain,
  codomain = NULL,
  id = "function",
  properties = character(),
  constants = ps(),
  packages = character(),
  check_values = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
R function that encodes objective and expects a list of lists that contains multiple x values, e.g. \code{list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4))}.
The function must return a \code{\link[data.table:data.table]{data.table::data.table()}} that contains one y-column for single-criteria functions and multiple y-columns for multi-criteria functions, e.g.  \code{data.table(y = 1:2)} or \code{data.table(y1 = 1:2, y2 = 3:4)}.}

\item{\code{domain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies domain of function.
The \link[paradox:ParamSet]{paradox::ParamSet} should describe all possible input parameters of the objective function.
This includes their \code{id}, their types and the possible range.}

\item{\code{codomain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies codomain of function.
Most importantly the tags of each output "Parameter" define whether it should
be minimized or maximized.  The default is to minimize each component.}

\item{\code{id}}{(\code{character(1)}).}

\item{\code{properties}}{(\code{character()}).}

\item{\code{constants}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Changeable constants or parameters that are not subject to tuning can be stored and accessed here.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages to run the objective function.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunMany-eval_many"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunMany-eval_many}{}}}
\subsection{Method \code{eval_many()}}{
Evaluates input value(s) on the objective function.
Calls the R function supplied by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunMany$eval_many(xss)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(\code{list()})\cr
A list of lists that contains multiple x values, e.g. \code{list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4))}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} that contains one y-column for single-criteria functions and multiple y-columns for multi-criteria functions, e.g.  \code{data.table(y = 1:2)} or \code{data.table(y1 = 1:2, y2 = 3:4)}.
It may also contain additional columns that will be stored in the archive if called through the \link{OptimInstance}.
These extra columns are referred to as \emph{extras}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunMany-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunMany-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunMany$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
