% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_search.R
\name{local_search_control}
\alias{local_search_control}
\title{Local Search Control}
\usage{
local_search_control(
  minimize = TRUE,
  n_searches = 10L,
  n_steps = 5L,
  n_neighs = 10L,
  mut_sd = 0.1,
  stagnate_max = 10L
)
}
\arguments{
\item{minimize}{(\code{logical(1)})\cr
Whether to minimize the objective.}

\item{n_searches}{(\code{integer(1)})\cr
Number of local searches.}

\item{n_steps}{(\code{integer(1)})\cr
Number of steps per local search.}

\item{n_neighs}{(\code{integer(1)})\cr
Number of neighbors per local search.}

\item{mut_sd}{(\code{numeric(1)})\cr
Standard deviation of the mutation.}

\item{stagnate_max}{(\code{integer(1)})\cr
Maximum number of no-improvement steps for a local search before it is randomly restarted.}
}
\value{
(\code{local_search_control})\cr
List with control params as S3 object.
}
\description{
Control parameters for local search optimizer, see \code{\link[=local_search]{local_search()}} for details.
}
