% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MAP.GaussianNIG}
\alias{MAP.GaussianNIG}
\title{MAP estimate of a "GaussianNIG" object}
\usage{
\method{MAP}{GaussianNIG}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A named list, the MAP estimate of beta and sigma^2.
}
\description{
Generate the MAP estimate of "theta" in following Gaussian-NIG structure: \cr
     beta,sigma^2|gamma ~ NIG(gamma) \cr
     x|beta,sigma^2,X ~ Gaussian(X%*%beta,sigma^2) \cr
where gamma = (m,V,a,b) is the Normal-Inverse-Gamma(NIG) parameter, "m" is a numeric "location" parameter; "V" is a symmetric positive definite matrix representing the "scale" parameters; "a" and "b" are the "shape" and "rate" parameter of the Inverse Gamma distribution. \cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
MAP is {beta,sigma^2}_MAP = argmax_{beta,sigma^2} p(beta,sigma^2|gamma,x,X).
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
X <- 1:20
x <- rnorm(20)+ X*0.3
ss <- sufficientStatistics(obj = obj,X=X,x=x)
posterior(obj = obj,ss = ss)
MAP(obj)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Dowloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}}
}
