% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosteriorPredictive.GaussianNIG}
\alias{dPosteriorPredictive.GaussianNIG}
\title{Posterior predictive density function of a "GaussianNIG" object}
\usage{
\method{dPosteriorPredictive}{GaussianNIG}(obj, x, X, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{x}{numeric, must satisfy length(x) = nrow(X).}

\item{X}{matrix, must satisfy length(x) = nrow(X).}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
   \deqn{x ~ Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 ~ InvGamma(a,b)}
   \deqn{beta ~ Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Posterior predictive density is p(x|m,V,a,b,X).
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
X <- 1:20
x <- rnorm(20)+ X*0.3
## out1 and out2 it should have the same values:
out1 <- dPosteriorPredictive(obj = obj, x = x,X=X,LOG = TRUE)
out2 <- numeric(length(x))
for(i in 1:length(x))
out2[i] <- marginalLikelihood(obj,x=x[i],X=X[i],LOG = TRUE)
max(abs(out1-out2))
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Downloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}}, \code{\link{dPosteriorPredictive.GaussianNIG}}, \code{\link{marginalLikelihood.GaussianNIG}}
}
