% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics.CatDP}
\alias{sufficientStatistics.CatDP}
\title{Sufficient statistics of a "CatDP" object}
\usage{
\method{sufficientStatistics}{CatDP}(obj, x, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{x}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{foreach}{logical, specifying whether to return the sufficient statistics for each observation. Default FALSE.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
An object of class "ssCatDP", the sufficient statistics of a set of categorical samples. Or an integer vector same as x if foreach=TRUE.
}
\description{
For following model structure:
     \deqn{pi|alpha ~ DP(alpha,U)}
     \deqn{x|pi ~ Categorical(pi)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers.Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatDP, x can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatDP" object. \cr
The sufficient statistics of a set of samples x is:
\itemize{
   \item unique positive integer values
   \item effective counts of the unique positive integers
}
}
\examples{
x <- sample(1L:10L,size = 4,replace = TRUE)
obj <- CatDP()
## an object of class "ssCatDP", which contains the counts of each unique integer
sufficientStatistics(obj=obj,x=x)
## will return x itself
sufficientStatistics(obj=obj,x=x,foreach = TRUE)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatDP}}, \code{\link{sufficientStatistics_Weighted.CatDP}}
}
