% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{sufficientStatistics.GaussianGaussian}
\alias{sufficientStatistics.GaussianGaussian}
\title{Sufficient statistics of a "GaussianGaussian" object}
\usage{
\method{sufficientStatistics}{GaussianGaussian}(obj, x, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "GaussianGaussian" object.}

\item{x}{matrix, Gaussian samples, when x is a matrix, each row is a sample of dimension ncol(x). when x is a vector, x is length(x) samples of dimension 1.}

\item{foreach}{logical, specifying whether to return the sufficient statistics for each observation. Default FALSE.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
If foreach=TRUE, will return a list of sufficient statistics for each row of x, otherwise will return the sufficient statistics of x as a whole.
}
\description{
For following model structure:
     \deqn{x ~ Gaussian(mu,Sigma)}
     \deqn{mu ~ Gaussian(m,S)}
Where Sigma is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The sufficient statistics of a set of samples x (each row of x is a sample) are: \cr
\itemize{
 \item the effective number of samples N=nrow(x)
 \item the sample sum xsum = colSums(x)
}
}
\examples{
obj <- GaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),m=c(0.2,0.5),S=diag(2)))
x <- rGaussian(100,c(0,0),Sigma = matrix(c(2,1,1,2),2,2))
sufficientStatistics(obj = obj,x=x)
sufficientStatistics(obj = obj,x=x,foreach=TRUE)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.
}
\seealso{
\code{\link{GaussianGaussian}}, \code{\link{sufficientStatistics_Weighted.GaussianGaussian}}
}
