% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{inferenceJointGaussian}
\alias{inferenceJointGaussian}
\title{Inference in joint Gaussian distribution}
\usage{
inferenceJointGaussian(x2, mu, Sigma = NULL, Precision = NULL)
}
\arguments{
\item{x2}{numeric, an sample of X2, satisfying length(x2)<D, D is the dimension of the joint distribution.}

\item{mu}{numeric, length D mean vector. mu=c(mu_X1,mu_X2)/.}

\item{Sigma}{DxD covariance matrix. At least one of Sigma and Precision should be non-NULL.}

\item{Precision}{DxD precision matrix, satisfying Precision = inverse(Sigma). At least one of Sigma and Precision should be non-NULL.}
}
\value{
A named list containing the conditional mean and covariance matrix.
}
\description{
For the model structure
   \deqn{x1,x2|mu,Sigma \sim Gaussian(mu,Sigma)}
   \deqn{x1|x2,mu,Sigma \sim Gaussian(mu12,Sigma12)}
}
\examples{
tmp <- matrix(runif(100),20,5)
S <- crossprod(tmp)                 #some synthetic covariance matrix
P <- solve(S)
m <- runif(5)
x2 <- runif(3)
inferenceJointGaussian(x2 = x2,mu = m,Precision = P)
}
