% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-classes.R, R/utils-mutate.R
\name{mutate.bcdc_promise}
\alias{mutate.bcdc_promise}
\alias{mutate}
\title{Throw an informative error when attempting mutate on a \code{bcdc_promise} object}
\usage{
\method{mutate}{bcdc_promise}(.data, ...)
}
\arguments{
\item{.data}{object of class \code{bcdc_promise} (likely passed from \code{\link[=bcdc_query_geodata]{bcdc_query_geodata()}})}

\item{...}{One or more unquoted expressions separated by commas. See details.}
}
\description{
The CQL syntax to generate WFS calls does not current allow arithmetic operations. Therefore
this function exists solely to generate an informative error that suggests an alternative
approach to use mutate with bcdata

See \code{dplyr::\link[dplyr]{mutate}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{bcdc_promise}: mutate.bcdc_promise
}}

\examples{
\donttest{

## Mutate columns
try(
  bcdc_query_geodata("bc-airports") \%>\%
    mutate(LATITUDE * 100)
)
}

}
\keyword{internal}
