% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcdc-get-citation.R
\name{bcdc_get_citation}
\alias{bcdc_get_citation}
\title{Generate a bibentry from a Data Catalogue Record}
\usage{
bcdc_get_citation(record)
}
\arguments{
\item{record}{either a \code{bcdc_record} object (from the result of \code{bcdc_get_record()}),
a character string denoting the name or ID of a resource (or the URL)

It is advised to use the permanent ID for a record rather than the
human-readable name to guard against future name changes of the record.
If you use the human-readable name a warning will be issued once per
session. You can silence these warnings altogether by setting an option:
\code{options("silence_named_get_data_warning" = TRUE)} - which you can set
in your .Rprofile file so the option persists across sessions.}
}
\description{
Generate a "TechReport" bibentry object directly from a catalogue record.
The primary use of this function is as a helper to create a \code{.bib} file for use
in reference management software to cite data from the B.C. Data Catalogue.
This function is likely to be starting place for this process and manual
adjustment will often be needed. The bibentries are not designed to be
authoritative and may not reflect all fields required for individual
citation requirements.
}
\examples{

try(
 bcdc_get_citation("76b1b7a3-2112-4444-857a-afccf7b20da8")
)

## Or directly on a record object
try(
 bcdc_get_citation(bcdc_get_record("76b1b7a3-2112-4444-857a-afccf7b20da8"))
)
}
\seealso{
\code{\link[utils:bibentry]{utils::bibentry()}}
}
