% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcmarg.R
\name{bcmarg}
\alias{bcmarg}
\title{Marginal Model of the Mixed Effect Model with the Box-Cox Transformation.}
\usage{
bcmarg(
  formula,
  data,
  time = NULL,
  id = NULL,
  structure = "UN",
  lmdint = c(-3, 3)
)
}
\arguments{
\item{formula}{a two-sided linear formula object describing the model, with
the response on the left of a ~ operator and the terms, separated by +
operators, on the right.}

\item{data}{a data frame containing the variables used in the model.}

\item{time}{time variable name for repeated measurements. The default is
NULL.}

\item{id}{subject id variable name for repeated measurements. The default is
NULL.}

\item{structure}{specify the covariance structure from c("UN", "CS",
"AR(1)"). The default is "UN".}

\item{lmdint}{a vector containing the end-points of the interval to be
searched for a transformation parameter. The default is c(-3, 3).}
}
\value{
an object of class "\code{bcmarg}". Objects of this class have
methods for the generic functions  \code{coef}, \code{logLik},
\code{print}, and \code{summary}. The object includes following components
for the marginal model parameter inference:
\describe{
  \item{\code{lambda}}{a numeric value of the estimate of the transformation
        parameter.}
  \item{\code{beta}}{a vector with the estimates of the regression
        parameters.}
  \item{\code{alpha}}{a vector with the estimates of the covariance
        parameters.}
  \item{\code{V}}{variance-covariance matrix for any subject with no missing
        values.}
  \item{\code{betainf}}{a matrix containing the inference results for
       \code{beta} under the assumption that lambda is known.
       Note that standard errors might be underestimated
       although statistical tests would be asymptotically valid.}
  \item{\code{Vtheta.mod}}{model-based variance-covariance matrix for MLE of
        the vector of all parameters: \code{c(lambda, beta, alpha)}.}
  \item{\code{Vtheta.rob}}{robust variance-covariance matrix for MLE of
        the vector of all parameters.}
  \item{\code{logLik}}{a numeric value of the maximized likelihood.}
  \item{\code{adj.prm}}{a vector with parameters used for the empirical
        small sample adjustment in \code{\link{bcmmrm}}:
        c(number of subjects, number of completed subjects, number of
        outcome observations, number of missing observations).}
  \item{\code{glsObject}}{an object of "\code{gls}" (or "\code{lm}" when
        \code{time} and \code{id} are not specified) containing results of
        \code{gls} (or \code{lm}) function on the transformed scale. }
}
}
\description{
\code{bcmarg} returns the inference results the parameters of
  the marginal model of the linear mixed effect model with the Box-Cox
  transformation proposed by Maruo et al. (2017). If time and id are not
  specified, inference results reduce to the results for the context of
  linear regression model provided by Maruo et al. (2015).
}
\examples{
 data(aidscd4)
 bcmarg(cd4 ~ as.factor(treatment) * as.factor(weekc) + age,
        data = aidscd4, time = weekc, id = id, structure = "AR(1)")

}
\references{
\itemize{
  \item Maruo, K., Isogawa, N., Gosho, M. (2015). Inference of median
        difference based on the Box-Cox model in randomized clinical trials.
        \emph{Statistics in Medicine}, 34, 1634-1644,
        \url{https://doi.org/10.1002/sim.6408}.\cr
  \item Maruo, K., Yamaguchi, Y., Noma, H., Gosho, M. (2017). Interpretable
        inference on the mixed effect model with the Box-Cox transformation.
        \emph{Statistics in Medicine}, 36, 2420-2434,
        \url{https://doi.org/10.1002/sim.7279}.
}
}
\seealso{
\code{\link{bcmmrm}} \code{\link{gls}}
}
