% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorEml.R
\docType{class}
\name{ExtractorEml}
\alias{ExtractorEml}
\title{Class to handle email files with eml extension}
\usage{
ExtractorEml
}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date from an eml type file.
}
\section{Constructor}{

\code{ExtractorEml$new(path)}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the eml type file.
}
\item{\strong{PartSelectedOnMPAlternative:}}{
(\emph{character}) configuration to read the eml files. If it is NULL, checks
if is defined in the \strong{"extractorEML.mpaPartSelected"} field of
\emph{\link{bdpar.Options}} variable.
}
}
}
}
}

\section{Details}{

The way to indicate which part to choose in the email, when is a multipart email,
is through the \strong{"extractorEML.mpaPartSelected"}
field of \emph{\link{bdpar.Options}} variable.
}

\section{Note}{

To be able to use this class it is necessary to have Python installed.
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\section{Methods}{

\itemize{
\item{\bold{obtainDate:}}{
obtains the date of the eml file. Calls the function \emph{read_emails}
and obtains the date of the file indicated in the path and then transforms it
into the generic date format, that is "\%a \%b \%d \%H:\%M:\%S \%Z \%Y"
(Example: "Thu May 02 06:52:36 UTC 2013").
\itemize{
\item{\emph{Usage:}}{
\code{obtainDate()}
}
}
}

\item{\bold{obtainSource:}}{
obtains the source of the eml file. Calls the function \emph{read_emails}
and obtains the source of the file indicated in the path. In addition, it
initializes the data with the initial source.
\itemize{
\item{\emph{Usage:}}{
\code{obtainSource()}
}
}
}

\item{\bold{getPartSelectedOnMPAlternative:}}{
gets of \code{PartSelectedOnMPAlternative} variable.
\itemize{
\item{\emph{Usage:}}{
\code{getPartSelectedOnMPAlternative()}
}
\item{\emph{Value:}}{
value of \code{PartSelectedOnMPAlternative} variable.
}
}
}

\item{\bold{setPartSelectedOnMPAlternative:}}{
sets of \code{PartSelectedOnMPAlternative} variable.
\itemize{
\item{\emph{Usage:}}{
\code{setPartSelectedOnMPAlternative(PartSelectedOnMPAlternative)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{PartSelectedOnMPAlternative}}{
(\emph{character}) the new value of \code{PartSelectedOnMPAlternative} variable.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{PartSelectedOnMPAlternative:}}{
 (\emph{character}) configuration to read the eml files. Indicates whether the
 text/plain part or the text/html part is read in multipart emails.
}
}
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}},
\code{\link{Instance}}
}
