% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeeCSVPipe.R
\name{TeeCSVPipe}
\alias{TeeCSVPipe}
\title{Class to handle a CSV with the properties field of the preprocessed
Instance}
\description{
Complete a CSV with the properties of the preprocessed
\code{\link{Instance}}.
}
\section{Details}{

The path to save the properties should be defined in the
\strong{"teeCSVPipe.output.path"} field of \emph{\link{bdpar.Options}}
variable.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{SlangPipe}}, \code{\link{StopWordPipe}},
         \code{\link{StoreFileExtPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{TeeCSVPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TeeCSVPipe-new}{\code{TeeCSVPipe$new()}}
\item \href{#method-TeeCSVPipe-pipe}{\code{TeeCSVPipe$pipe()}}
\item \href{#method-TeeCSVPipe-clone}{\code{TeeCSVPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TeeCSVPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-TeeCSVPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{TeeCSVPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TeeCSVPipe$new(
  propertyName = "",
  alwaysBeforeDeps = list(),
  notAfterDeps = list(),
  withData = TRUE,
  withSource = TRUE,
  outputPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{withData}}{A \code{\link{logical}} value. Indicates if the data is
added to CSV.}

\item{\code{withSource}}{A \code{\link{logical}} value. Indicates if the source
is added to CSV.}

\item{\code{outputPath}}{A \code{\link{character}} value. The path of CSV.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TeeCSVPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-TeeCSVPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Completes the CSV with the preprocessed
\code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TeeCSVPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TeeCSVPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TeeCSVPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TeeCSVPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
