% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_beast2_installed.R
\name{is_beast2_installed}
\alias{is_beast2_installed}
\title{Checks if BEAST2 is installed}
\usage{
is_beast2_installed(folder_name = get_default_beast2_folder(),
  os = rappdirs::app_dir()$os)
}
\arguments{
\item{folder_name}{name of the folder where the BEAST2 files are put.
The name of the BEAST2 binary file will be at
\code{[folder_name]/beast/bin/beast}
The name of the BEAST2 jar file will be at
\code{[folder_name]/beast/lib/beast.jar}}

\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
TRUE if BEAST2 is installed
}
\description{
Checks if BEAST2 is installed
}
\examples{
  if (is_beast2_installed()) {
    print("BEAST2 is installed")
  }
}
\author{
Richèl J.C. Bilderbeek
}
