% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beast2_path.R
\name{check_beast2_path}
\alias{check_beast2_path}
\title{Checks the BEAST2 \code{.jar} path.
Will stop if there is a problem with the BEAST2 \code{.jar} path.}
\usage{
check_beast2_path(beast2_path)
}
\arguments{
\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
nothing.
  Will call \code{\link{stop}} if the BEAST2 \code{.jar} path has a problem
}
\description{
Checks the BEAST2 \code{.jar} path.
Will stop if there is a problem with the BEAST2 \code{.jar} path.
}
\examples{
check_empty_beaustier_folders()

if (is_beast2_installed()) {
  beast2_path <- get_default_beast2_jar_path()
  check_beast2_path(beast2_path)
}

check_empty_beaustier_folders()
}
\author{
Richèl J.C. Bilderbeek
}
