% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_strict_clock_model.R
\name{is_strict_clock_model}
\alias{is_strict_clock_model}
\title{Determine if the object is a valid strict clock model,
  as returned by \code{\link{create_strict_clock_model}}}
\usage{
is_strict_clock_model(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid strict clock model}
}
\value{
TRUE if x is a valid strict clock model, FALSE otherwise
}
\description{
Determine if the object is a valid strict clock model,
  as returned by \code{\link{create_strict_clock_model}}
}
\examples{
  strict_clock_model <- create_strict_clock_model()

  # rln: Relaxed Log-Normal
  rln_clock_model <- create_rln_clock_model()
  testit::assert(!beautier:::is_strict_clock_model(rln_clock_model))
}
\seealso{
\code{\link{create_clock_model}} shows an overview of
  functions to create a clock model
}
\author{
Richel J.C. Bilderbeek
}
