% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mrca_prior.R
\name{check_mrca_prior}
\alias{check_mrca_prior}
\title{Check if the MRCA prior is a valid MRCA prior.}
\usage{
check_mrca_prior(mrca_prior)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the MRCA prior is invalid.
}
\examples{
check_empty_beautier_folder()

fasta_filename <- get_beautier_path("anthus_aco.fas")
mrca_prior <- create_mrca_prior(
  alignment_id = get_alignment_id(fasta_filename = fasta_filename),
  taxa_names = get_taxa_names(filename = fasta_filename)
)
mrca_prior <- create_mrca_prior(
 alignment_id = get_alignment_id(fasta_filename = fasta_filename),
 taxa_names = get_taxa_names(filename = fasta_filename)
)
check_mrca_prior(mrca_prior)

check_empty_beautier_folder()
}
\seealso{
Use \link{create_mrca_prior} to create a valid MRCA prior
}
\author{
Richèl J.C. Bilderbeek
}
