% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_models_to_xml_prior_distr.R
\name{clock_models_to_xml_prior_distr}
\alias{clock_models_to_xml_prior_distr}
\title{Represent the clock models as XML}
\usage{
clock_models_to_xml_prior_distr(
  clock_models,
  mrca_priors = NA,
  tipdates_filename = NA
)
}
\arguments{
\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
a character vector of XML strings
}
\description{
Represent the clock models as XML
}
\examples{
 # <distribution id="posterior" spec="util.CompoundDistribution">
 #     <distribution id="prior" spec="util.CompoundDistribution">
 #       HERE, where the ID of the distribution is 'prior'
 #     </distribution>
 #     <distribution id="likelihood" ...>
 #     </distribution>
 # </distribution>
}
\author{
Richèl J.C. Bilderbeek
}
