% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_contrast.R
\name{apply_contrast}
\alias{apply_contrast}
\title{Apply contrast to calculate marginal estimate of treatment effect and corresponding standard error}
\usage{
apply_contrast(
  object,
  contrast = c("diff", "rr", "or", "logrr", "logor"),
  reference
)
}
\arguments{
\item{object}{a fitted \code{\link[stats]{glm}} object augmented with
\code{counterfactual.predictions}, \code{counterfactual.means} and \code{robust_varcov}.}

\item{contrast}{a string specifying the type of contrast to apply.
Accepted values are "diff" (risk difference), "rr" (risk ratio),
"or" (odds ratio), "logrr" (log risk ratio), "logor" (log odds ratio).
Note: log-transformed ratios (logrr and logor) work better compared to rr
and or when computing confidence intervals using normal approximation.
The choice of contrast affects how treatment effects are calculated and
interpreted. Default is \code{diff}.}

\item{reference}{a string indicating which treatment group should be considered as
the reference level. Accepted values are one of the levels in the treatment
variable. Default to the first level used in the \code{glm} object.

This parameter influences the calculation of treatment effects
relative to the chosen reference group.}
}
\value{
An updated \code{glm} object with two additional components
appended: \code{marginal_est} (marginal estimate of the treatment effect)
and \code{marginal_se} (standard error of the marginal estimate).
These appended component provide crucial information for interpreting
the treatment effect using the specified contrast method.
}
\description{
Calculates the marginal estimate of treatment effect and its corresponding
standard error based on a fitted GLM object using specified contrast (summary
measure) methods
}
\details{
The \code{apply_constrast()} functions computes the summary measure between two arms
based on the estimated marginal effect and its variance-covariance matrix using
the Delta method.

Note: Ensure that the \code{glm} object has been adequately prepared with
\code{average_predictions()} and \code{estimate_varcov()}
before applying \code{apply_contrast()}. Failure to do so may result in
errors indicating missing components.
}
\examples{
trial01$trtp <- factor(trial01$trtp)
fit1 <- glm(aval ~ trtp + bl_cov, family = "binomial", data = trial01) |>
  predict_counterfactuals(trt = "trtp") |>
  average_predictions() |>
  estimate_varcov(method = "Ye") |>
  apply_contrast("diff", reference = "0")

# Assuming `trial01` is a dataset with treatment (`trtp`)
# and baseline covariate (`bl_cov`)
trial01$trtp <- factor(trial01$trtp)
fit1 <- glm(aval ~ trtp + bl_cov, family = "binomial", data = trial01)

# Preprocess fit1 as required by apply_contrast
fit2 <- fit1 |>
  predict_counterfactuals(trt = "trtp") |>
  average_predictions() |>
  estimate_varcov(method = "Ye")

# Apply contrast to calculate marginal estimates
fit3 <- apply_contrast(fit2, contrast = "diff", reference = "0")

fit3$marginal_est
fit3$marginal_se

}
\seealso{
\code{\link[=get_marginal_effect]{get_marginal_effect()}} for estimating marginal effects directly
from an original \code{\link[stats]{glm}} object
}
