% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_counterfactuals.R
\name{predict_counterfactuals}
\alias{predict_counterfactuals}
\title{Predict counterfactual outcomes in GLM models}
\usage{
predict_counterfactuals(object, trt)
}
\arguments{
\item{object}{a fitted \code{\link[stats]{glm}} object for which
counterfactual predictions are desired.}

\item{trt}{a string specifying the name of the treatment variable
in the model formula. It must be one of the linear predictor variables used
in fitting the \code{object}.}
}
\value{
an updated \code{glm} object appended with an
additional component \code{counterfactual.predictions}.

This component contains a tibble with two columns: \code{cf_pred_0} and \code{cf_pred_1},
representing counterfactual predictions for each level of the
treatment variable. A descriptive \code{label} attribute explains the counterfactual
scenario associated with each column.
}
\description{
This function calculates counterfactual predictions for each level of a
specified treatment variable in a generalized linear model (GLM).
It is designed to aid in the assessment of treatment effects by predicting
outcomes under different treatments under causal inference framework.
}
\details{
The function works by creating two new datasets from the original data used
to fit the GLM model. In these datasets, the treatment variable
is set to each of its levels across all records (e.g., patients).

Predictions are then made for each dataset based on the fitted GLM model,
simulating the response variable under each treatment condition.

The results are stored in a tidy format and appended to the original model
object for further analysis or inspection.

For averaging counterfactual outcomes, apply \code{average_predictions()}.
}
\examples{
# Preparing data and fitting a GLM model
trial01$trtp <- factor(trial01$trtp)
fit1 <- glm(aval ~ trtp + bl_cov, family = "binomial", data = trial01)

# Generating counterfactual predictions
fit2 <- predict_counterfactuals(fit1, "trtp")

# Accessing the counterfactual predictions
fit2$counterfactual.predictions
attributes(fit2$counterfactual.predictions)

}
\seealso{
\code{\link[=average_predictions]{average_predictions()}} for averaging counterfactual
predictions.

\code{\link[=get_marginal_effect]{get_marginal_effect()}} for estimating marginal effects directly
from an original \code{\link[stats]{glm}} object
}
