% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDWD.R
\name{dataDWD}
\alias{dataDWD}
\title{download data from DWD}
\usage{
dataDWD(file,
  base1 = "ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate",
  base2 = "hourly/precipitation/recent", dir = "DWDdata", browse = 0:2,
  meta = 0:2, read = TRUE, format = NA, quiet = FALSE, ...)
}
\arguments{
\item{file}{Filename (must be available at the location given by \code{base1} and \code{base2})}

\item{base1}{Main directory of DWD ftp server (can probably always be left unchanged)}

\item{base2}{Characterstring with subdirectory. DEFAULT: "hourly/precipitation/recent"}

\item{dir}{Writeable directory on your computer. Created if not existent.
DEFAULT: "DWDdata" at your current \code{\link{getwd}()}}

\item{browse}{Integer specifying whether and how to open repository via \code{\link{browseURL}}.\cr
0 for regular file download. \cr
1 to open \code{base1}.\cr
2 to open \code{base1/base2}).\cr
If base= 1 or 2, no \code{dir} is created and no download performed. DEFAULT: 0}

\item{meta}{Integer specifying whether to get metadata instead of actual data.\cr
0 for regular file. \cr
1 for meta data of all stations
(\code{meta} is automatically set to 1 if \code{file} ends in ".txt".
Column widths for \code{\link{read.fwf}} are computed internally).\cr
2 for a list of the available files (requires \code{RCurl} to be installed.
If meta=2, \code{file=""} is possible, as it is ignored anyways).\cr
DEFAULT: 0}

\item{read}{Read the file with \code{\link{readDWD}}?
If FALSE, only download is performed. DEFAULT: TRUE}

\item{format}{Format used in \code{\link{strptime}} to convert date/time column,
see \code{\link{readDWD}}. DEFAULT: NA}

\item{quiet}{Suppress message about directory? DEFAULT: FALSE}

\item{\dots}{Further arguments currently ignored}
}
\value{
data.frame of the desired dataset (returned by \code{\link{readDWD}} if meta=0), 
        presuming downloading and processing were successfull.
        Alternatively, links that were opened if \code{browse}!=0.
}
\description{
Get climate data from the German Weather Service (DWD) FTP-server.
The desired .zip dataset is downloaded into \code{dir}, read, processed and returned as a data.frame
}
\note{
These functions are now in the package rdwd and will be removed here!
\url{https://github.com/brry/rdwd}
}
\examples{

# Don't use this anymore, use instead: 
#   browseURL("https://github.com/brry/rdwd#rdwd")


}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2016
}
\seealso{
\code{\link{readDWD}}, \code{\link{download.file}}, \code{\link{monthAxis}}, \code{\link{climateGraph}}
}
\keyword{data}
\keyword{file}

