% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-s-cor-nb.R
\name{SCorNB}
\alias{SCorNB}
\title{Estimate Semipartial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
SCorNB(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{r_{s}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{r_{s}}.}
\item{est}{Vector of estimated
\eqn{r_{s}}.}
\item{fun}{Function used ("SCorMC").}
}
}
\description{
Estimate Semipartial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of semipartial correlation coefficients
(\eqn{r_{s}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{r_{s}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of sample covariances
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for standardized regression slopes
rs <- SCorNB(nb)
# Methods --------------------------------------------------------
print(rs)
summary(rs)
coef(rs)
vcov(rs)
confint(rs, level = 0.95)
}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{.CI}()},
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{RSqNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{scor}
