% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_k.R
\name{beta_k}
\alias{beta_k}
\title{Fit the K.. model}
\usage{
beta_k(data, M = 3, parallel_process = FALSE, seed = NULL)
}
\arguments{
\item{data}{A dataframe of dimension \eqn{C \times N} containing methylation values for \eqn{C} CpG sites from \eqn{R = 1} samples collected from \eqn{N} patients.
Samples are grouped together in the dataframe such that the columns are ordered as Sample1_Patient1, Sample1_Patient2, etc.}

\item{M}{Number of methylation states to be identified in a DNA sample.}

\item{parallel_process}{The "TRUE" option results in parallel processing of the models for increased computational efficiency. The default option has been set as "FALSE" due to package testing limitations.}

\item{seed}{Seed to allow for reproducibility (default = NULL).}
}
\value{
A list containing:
\itemize{
   \item cluster_size - The total number of CpG sites in each of the K clusters.
   \item llk - A vector containing the log-likelihood value at each step of the EM algorithm.
   \item alpha - The first shape parameter for the beta mixture model.
   \item delta - The second shape parameter for the beta mixture model.
   \item tau - The proportion of CpG sites in each cluster.
   \item z - A matrix of dimension \eqn{C \times K} containing the posterior probability of each CpG site belonging to each of the \eqn{K} clusters.
   \item classification - The classification corresponding to z, i.e. map(z).
   \item uncertainty - The uncertainty of each CpG site's clustering.    }
}
\description{
Fit the K.. model from the \code{\link[betaclust:betaclust]{betaclust}} family of beta mixture models for DNA methylation data.
             The K.. model analyses a single DNA sample and identifies the thresholds between the different methylation states.
}
\details{
The K.. model clusters each of the \eqn{C} CpG sites into one of \eqn{K} methylation states, based on data from \eqn{N} patients for one DNA sample (i.e. \eqn{R = 1}).
As each CpG site can belong to any of the \eqn{M = 3} methylation states (hypomethylated, hemimethylated or hypermethylated), the default value of \eqn{K = M = 3}.
Under the K.. model the shape parameters of each cluster are constrained to be equal for each patient. The returned object from this function can be passed as an input parameter to the
\code{\link[betaclust:threshold]{threshold}} function available in this package to calculate the thresholds between the methylation states.
}
\examples{
my.seed <- 190
M <- 3
data_output <- beta_k(pca.methylation.data[1:30,2:5], M,
                      parallel_process = FALSE, seed = my.seed)
thresholds <- threshold(data_output, pca.methylation.data[1:30,2:5], "K..")
}
\seealso{
\code{\link{beta_kn}}

\code{\link{betaclust}}

\code{\link{threshold}}
}
