% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/betas.R
\name{betas.lm}
\alias{betas.lm}
\title{Compute standardized beta coeffizients for linear regression models}
\usage{
betas.lm(MOD)
}
\arguments{
\item{MOD}{A model of class \code{lm}.}
}
\value{
A data.frame with two columns
\tabular{ll}{
  \code{beta} \tab standardized beta coefficients\cr
  \code{se.beta} \tab standard errors for the beta coefficients\cr
}
}
\description{
Compute standardized beta coeffizients for linear regression models
}
\examples{
data <- pisa2012che

## linear regression models with numerical covariates only
fit1 <- lm(MATH ~ ESCS + USEMATH, data)
betas.lm(fit1)

## linear regression models with numerical and factorial covariates
fit2 <- lm(MATH ~ ESCS + USEMATH + ST04Q01 + FAMSTRUC + ST28Q01, data)
betas.lm(fit2)

## weighted linear regression models
fit3 <- lm(MATH ~ ESCS + USEMATH, data, weights = W_FSTUWT)
betas.lm(fit3)

fit4 <- lm(MATH ~ ESCS + USEMATH + ST04Q01 + FAMSTRUC + ST28Q01, data, weights = W_FSTUWT)
betas.lm(fit4)
}

