% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/betas.R
\name{betas.lmr}
\alias{betas.lmr}
\title{Compute standardized beta coeffizients for robust linear regression models}
\usage{
betas.lmr(object, classic = FALSE)
}
\arguments{
\item{object}{A model of class \code{lmRob}.}

\item{classic}{Logical TRUE for classic covariance estimation.}
}
\value{
Vector with standardized beta coefficients.
}
\description{
Compute standardized beta coeffizients for robust linear regression models
}
\examples{
library(robust)
data <- pisa2012che

## robust estimation of betas
fit1 <- lmRob(MATH ~ ESCS, data)
betas.lmr(fit1)

## example where robust variance cannot be computed,
## instead the classical variance is used.
fit2 <- lmRob(MATH ~ ESCS + USEMATH, data)
betas.lmr(fit2)
}

