% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_misc.R
\name{ComputeHDI}
\alias{ComputeHDI}
\title{Compute HDI}
\usage{
ComputeHDI(data, credible.region)
}
\arguments{
\item{data}{data to compute HDI from}

\item{credible.region}{summarize uncertainty by defining a region of most credible values (e.g., 95 percent of the distribution), Default: 0.95}
}
\value{
Return HDI
}
\description{
Compute highest density interval (HDI) from posterior output
}
\details{
values within the HDI have higher probability density than values outside the HDI, and the values inside the HDI have a total probability equal to the credible region (e.g., 95 percent).
}
\examples{
set.seed(1)
data <-rnorm(100,0,1)
credible.region <- 0.95
ComputeHDI(data,credible.region)
# HDIlo HDIhi
# -1.99 1.60
}
