% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_big_lm.R
\name{bigLmPure}
\alias{bigLmPure}
\title{fast and memory efficient linear model fitting}
\usage{
bigLmPure(X, y, method = 0L)
}
\arguments{
\item{X}{input model matrix. must be a big.matrix object (type = 8 for double)}

\item{y}{numeric response vector of length nobs.}

\item{method}{an integer scalar with value 0 for the LLT Cholesky or 1 for the LDLT Cholesky}
}
\value{
A list with the elements
\item{coefficients}{a vector of coefficients}
\item{se}{a vector of the standard errors of the coefficient estimates}
\item{rank}{a scalar denoting the computed rank of the model matrix}
\item{df.residual}{a scalar denoting the degrees of freedom in the model}
\item{residuals}{the vector of residuals}
\item{s}{a numeric scalar - the root mean square for residuals}
\item{fitted.values}{the vector of fitted values}
}
\description{
fast and memory efficient linear model fitting
}
\examples{

library(bigmemory)

nrows <- 50000
ncols <- 50
bkFile <- "bigmat2.bk"
descFile <- "bigmatk2.desc"
bigmat <- filebacked.big.matrix(nrow=nrows, ncol=ncols, type="double",
                                backingfile=bkFile, backingpath=".",
                                descriptorfile=descFile,
                                dimnames=c(NULL,NULL))

# Each column value with be the column number multiplied by
# samples from a standard normal distribution.
set.seed(123)
for (i in 1:ncols) bigmat[,i] = rnorm(nrows)*i

y <- rnorm(nrows) + bigmat[,1]

system.time(lmr1 <- bigLmPure(bigmat, y))

system.time(lmr2 <- lm.fit(x = bigmat[,], y = y))

max(abs(coef(lmr1) - coef(lmr2)))


}

