% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoSVD.R
\name{bed_randomSVD}
\alias{bed_randomSVD}
\title{Randomized partial SVD}
\usage{
bed_randomSVD(
  obj.bed,
  fun.scaling = bed_scaleBinom,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  k = 10,
  tol = 1e-04,
  verbose = FALSE,
  ncores = 1
)
}
\arguments{
\item{obj.bed}{Object of type \link{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}

\item{fun.scaling}{A function with parameters \code{X}, \code{ind.row} and \code{ind.col},
and that returns a data.frame with \verb{$center} and \verb{$scale} for the columns
corresponding to \code{ind.col}, to scale each of their elements such as followed:
\deqn{\frac{X_{i,j} - center_j}{scale_j}.} Default doesn't use any scaling.
You can also provide your own \code{center} and \code{scale} by using \code{\link[bigstatsr:as_scaling_fun]{as_scaling_fun()}}.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{k}{Number of singular vectors/values to compute. Default is \code{10}.
\strong{This algorithm should be used to compute only a few singular vectors/values.}}

\item{tol}{Precision parameter of \link[RSpectra:svds]{svds}. Default is \code{1e-4}.}

\item{verbose}{Should some progress be printed? Default is \code{FALSE}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
A named list (an S3 class "big_SVD") of
\itemize{
\item \code{d}, the singular values,
\item \code{u}, the left singular vectors,
\item \code{v}, the right singular vectors,
\item \code{niter}, the number of the iteration of the algorithm,
\item \code{nops}, number of Matrix-Vector multiplications used,
\item \code{center}, the centering vector,
\item \code{scale}, the scaling vector.
}

Note that to obtain the Principal Components, you must use
\link[bigstatsr:predict.big_SVD]{predict} on the result. See examples.
}
\description{
Partial SVD (or PCA) of a genotype matrix stored as a PLINK (.bed) file.#'
}
\examples{
bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

str(bed_randomSVD(obj.bed))

}
