% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fst.R
\name{snp_fst}
\alias{snp_fst}
\title{Fixation index (Fst)}
\usage{
snp_fst(list_df_af, min_maf = 0, overall = FALSE)
}
\arguments{
\item{list_df_af}{List of data frames with \verb{$af} (allele frequency per variant)
and \verb{$N} (sample size per variant). Typically, the outputs of \code{\link[=bed_MAF]{bed_MAF()}}.
Each new data frame of the list should correspond to a different population.}

\item{min_maf}{Minimum MAF threshold (for the average of populations) to be
included in the final results. Default is \code{0} (remove monomorphic variants).}

\item{overall}{Whether to compute Fst genome-wide (\code{TRUE}) or per variant
(\code{FALSE}, the default).}
}
\value{
If \code{overall}, then one value, otherwise a value for each variant
with missing values for the variants not passing \code{min_maf}.
This should be equivalent to using '\code{--fst --within}' in PLINK.
}
\description{
Fixation index (Fst), either per variant, or genome-wide
}
\examples{
bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

pop <- rep(1:3, c(143, 167, 207))
ind_pop <- split(seq_along(pop), pop)
list_df_af <- lapply(ind_pop, function(ind) bed_MAF(obj.bed, ind.row = ind))

snp_fst(list_df_af)
snp_fst(list_df_af[c(1, 2)], overall = TRUE)
snp_fst(list_df_af[c(1, 3)], overall = TRUE)
snp_fst(list_df_af[c(3, 2)], overall = TRUE)

}
\references{
Weir, B. S., & Cockerham, C. C. (1984). Estimating F-statistics for the
analysis of population structure. Evolution, 1358-1370.
}
